IF   EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[PDV_VD_IT_FISCAL_ALTERACAO]') 
					AND type in (N'U')) 
BEGIN
	DROP TABLE PDV_VD_IT_FISCAL_ALTERACAO
END
GO
CREATE TABLE [dbo].[PDV_VD_IT_FISCAL_ALTERACAO](
	[CD_CTR] [int] IDENTITY(1,1) NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_VD] [int] NOT NULL,
	[CD_IT] [int] NOT NULL,
	[CD_TRIB_FC] [varchar](50) NOT NULL,
	[TX_ICMS_IT] [money] NOT NULL,
	[TX_RED_IT] [money] NOT NULL,
	[CD_USU] [int] NULL,
	[DT_CAD] [datetime] NULL,
 CONSTRAINT [PK_PDV_VD_IT_FISCAL_ALTERACAO] PRIMARY KEY CLUSTERED 
(
	[CD_CTR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[PDV_VD_IT_FISCAL_ALTERACAO] ADD  CONSTRAINT [DF_PDV_VD_IT_FISCAL_ALTERACAO_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[PDV_VD_IT_FISCAL_ALTERACAO]  WITH CHECK ADD  CONSTRAINT [FK_PDV_VD_IT_FISCAL_ALTERACAO_PDV_VD_IT] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_VD], [CD_IT])
REFERENCES [dbo].[PDV_VD_IT] ([CD_EMP], [CD_FILIAL], [CD_VD], [CD_IT])

ALTER TABLE [dbo].[PDV_VD_IT_FISCAL_ALTERACAO] CHECK CONSTRAINT [FK_PDV_VD_IT_FISCAL_ALTERACAO_PDV_VD_IT]
